/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.imgcontrol;

import com.quantumdata.imgcontrol.CheckersPage;
import com.quantumdata.imgcontrol.ContrastBoxPage;
import com.quantumdata.imgcontrol.ImageControlPage;
import com.quantumdata.imgcontrol.Ramp12Page;
import com.quantumdata.imgcontrol.RampDif;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDCheckBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageControl
extends QDPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private RemoteInstrument m_instrument = null;
    private IQDPluginContext m_context;
    private JTabbedPane m_controlPages;
    private QDToolBar m_toolbar;
    private QDPanel m_fmtPanel;
    private QDLabel m_errMsg;
    private JComboBox m_peld;
    private JComboBox m_dvqm;
    private JComboBox m_clrSpace;
    private JComboBox m_nbpc;
    private QDLabel m_fmt;
    private QDCheckBox m_gamc;
    private boolean m_updating = false;

    public ImageControl(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.setSize(450, 600);
        this.setLayout(new BorderLayout());
        ImageControlPage.setMainWin(this);
        QDPanel qDPanel = new QDPanel(new BorderLayout());
        this.m_errMsg = new QDLabel();
        this.m_errMsg.setForeground(Color.red);
        qDPanel.add((Component)this.m_errMsg, "South");
        qDPanel.add((Component)this.getFormatPanel(), "North");
        this.add((Component)qDPanel, "South");
        this.m_controlPages = new JTabbedPane();
        this.add((Component)this.m_controlPages, "Center");
        this.m_controlPages.addChangeListener(this);
        this.m_controlPages.addTab("Ramp 12", new Ramp12Page());
        this.m_controlPages.addTab("Ramp Dif", new RampDif());
        this.m_controlPages.addTab("Checkers", new CheckersPage());
        this.m_controlPages.addTab("Contrast Box", new ContrastBoxPage());
        this.m_toolbar = new QDToolBar();
        this.add((Component)this.m_toolbar, "North");
        QDButton qDButton = new QDButton("");
        qDButton.setAction(new AbstractAction("Reset to Saved"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImageControl.this.getCurrentPage().load();
            }
        });
        this.m_toolbar.add(qDButton);
        qDButton = new QDButton("");
        qDButton.setAction(new AbstractAction("Save"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImageControl.this.getCurrentPage().save();
            }
        });
        this.m_toolbar.add(qDButton);
        qDButton = new QDButton("");
        qDButton.setAction(new AbstractAction("Set to Defaults"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImageControl.this.getCurrentPage().setToDefaults();
            }
        });
        this.m_toolbar.add(qDButton);
        ImageControlPage.setInstrument(null);
    }

    private QDPanel getFormatPanel() {
        this.m_fmtPanel = new QDPanel(new BorderLayout());
        Border border = BorderFactory.createEmptyBorder(3, 5, 3, 0);
        QDButton qDButton = new QDButton("");
        qDButton.setAction(new AbstractAction("Get"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                ImageControl.this.getFormatValues();
            }
        });
        QDPanel qDPanel = new QDPanel();
        QDPanel qDPanel2 = new QDPanel();
        this.m_fmt = new QDLabel(" ");
        qDPanel2.add(this.m_fmt);
        qDPanel2.add(qDButton);
        qDPanel.add(qDPanel2);
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(border);
        this.m_gamc = new QDCheckBox("GAMC");
        this.m_gamc.setActionCommand("GAMC");
        this.m_gamc.addActionListener(this);
        qDPanel2.add(this.m_gamc);
        qDPanel.add(qDPanel2);
        this.m_fmtPanel.add((Component)qDPanel, "North");
        qDPanel = new QDPanel();
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(border);
        QDLabel qDLabel = new QDLabel("PELD: ");
        qDPanel2.add(qDLabel);
        this.m_peld = new JComboBox();
        this.m_peld.addItem("8");
        this.m_peld.addItem("32");
        this.m_peld.setActionCommand("PELD");
        this.m_peld.addActionListener(this);
        qDPanel2.add(this.m_peld);
        qDPanel.add(qDPanel2);
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(border);
        qDLabel = new QDLabel("Range: ");
        qDPanel2.add(qDLabel);
        this.m_dvqm = new JComboBox();
        this.m_dvqm.addItem("Max");
        this.m_dvqm.addItem("Max TV");
        this.m_dvqm.addItem("Nom TV");
        this.m_dvqm.setActionCommand("DVQM");
        this.m_dvqm.addActionListener(this);
        qDPanel2.add(this.m_dvqm);
        qDPanel.add(qDPanel2);
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(border);
        qDLabel = new QDLabel("Clr Space: ");
        qDPanel2.add(qDLabel);
        this.m_clrSpace = new JComboBox();
        this.m_clrSpace.addItem("RGB");
        this.m_clrSpace.addItem("YCbCr 4:4:4");
        this.m_clrSpace.addItem("YCbCr 4:2:2");
        this.m_clrSpace.setActionCommand("CLSP");
        this.m_clrSpace.addActionListener(this);
        qDPanel2.add(this.m_clrSpace);
        qDPanel.add(qDPanel2);
        qDPanel2 = new QDPanel();
        qDPanel2.setBorder(border);
        qDLabel = new QDLabel("NBPC: ");
        qDPanel2.add(qDLabel);
        this.m_nbpc = new JComboBox();
        this.m_nbpc.addItem("8");
        this.m_nbpc.addItem("10");
        this.m_nbpc.addItem("12");
        this.m_nbpc.setActionCommand("NBPC");
        this.m_nbpc.addActionListener(this);
        qDPanel2.add(this.m_nbpc);
        qDPanel.add(qDPanel2);
        this.m_fmtPanel.add((Component)qDPanel, "South");
        return this.m_fmtPanel;
    }

    private ImageControlPage getCurrentPage() {
        ImageControlPage imageControlPage = (ImageControlPage)this.m_controlPages.getSelectedComponent();
        return imageControlPage;
    }

    public void setErrorMsg(String string) {
        this.m_errMsg.setText(string);
    }

    public void start() {
        this.m_instrument = this.m_context.getConnectionManager().getDefaultInstrument();
        ImageControlPage.setInstrument(this.m_instrument);
        if (!this.isSupportedUnit()) {
            return;
        }
        this.getCurrentPage().activate();
        try {
            int n = ImageControlPage.getInt("XVSI?");
            if (n != 4) {
                ImageControlPage.sendCmd("XVSI 4;FMTU");
            }
        }
        catch (InstrumentException instrumentException) {
            return;
        }
        this.getFormatValues();
    }

    private boolean isSupportedUnit() {
        Object object;
        Object object2;
        if (this.m_instrument == null || !this.m_instrument.isConnected()) {
            return true;
        }
        try {
            object2 = ImageControlPage.sendCmd("*IDN?");
            object = ((String)object2).split(",");
            if (((String[])object).length >= 2 && object[1].indexOf("881") != 0) {
                return true;
            }
        }
        catch (InstrumentException instrumentException) {
            // empty catch block
        }
        this.m_controlPages.setVisible(false);
        this.m_fmtPanel.setVisible(false);
        this.m_toolbar.setVisible(false);
        this.setLayout(new BorderLayout());
        object2 = new JPanel();
        object = new JLabel();
        ((JLabel)object).setText("The instrument does not support the Image Control feature.");
        ((Container)object2).add((Component)object);
        this.add((Component)object2, "Center");
        return false;
    }

    public boolean stop() {
        return true;
    }

    public RemoteInstrument getInstrument() {
        return this.m_instrument;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.getCurrentPage().activate();
    }

    private void getFormatValues() {
        int n;
        int n2;
        int n3;
        String string;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            n8 = ImageControlPage.getInt("PELD?");
            n7 = ImageControlPage.getInt("DVQM?");
            n6 = ImageControlPage.getInt("DVST?");
            n5 = ImageControlPage.getInt("NBPC?");
            n4 = ImageControlPage.getInt("DVSM?");
            string = ImageControlPage.sendCmd("FMTU?");
            n3 = ImageControlPage.getInt("HRES?");
            n2 = ImageControlPage.getInt("VRES?");
            n = ImageControlPage.getInt("GAMC?");
        }
        catch (InstrumentException instrumentException) {
            this.setCursor(cursor);
            return;
        }
        this.m_updating = true;
        this.m_fmt.setText(string + ": " + n3 + " x " + n2);
        this.m_gamc.setSelected(n != 0);
        switch (n8) {
            case 32: {
                this.m_peld.setSelectedIndex(1);
                break;
            }
            default: {
                this.m_peld.setSelectedIndex(0);
            }
        }
        this.m_dvqm.setSelectedIndex(n7);
        switch (n5) {
            case 10: {
                this.m_nbpc.setSelectedIndex(1);
                break;
            }
            case 12: {
                this.m_nbpc.setSelectedIndex(2);
                break;
            }
            default: {
                this.m_nbpc.setSelectedIndex(0);
            }
        }
        switch (n6) {
            case 15: {
                switch (n4) {
                    case 0: 
                    case 4: {
                        this.m_clrSpace.setSelectedIndex(1);
                        break;
                    }
                    case 2: {
                        this.m_clrSpace.setSelectedIndex(2);
                    }
                }
                break;
            }
            default: {
                this.m_clrSpace.setSelectedIndex(0);
            }
        }
        this.m_updating = false;
        this.setCursor(cursor);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.m_updating) {
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string = actionEvent.getActionCommand();
        String string2 = "";
        if (string.equalsIgnoreCase("PELD")) {
            int n = this.m_peld.getSelectedIndex();
            string2 = "PELD " + (n == 0 ? "8" : "32");
        } else if (string.equalsIgnoreCase("DVQM")) {
            string2 = "DVQM " + this.m_dvqm.getSelectedIndex();
        } else if (string.equalsIgnoreCase("CLSP")) {
            switch (this.m_clrSpace.getSelectedIndex()) {
                case 0: {
                    string2 = "DVST 10;DVSM 0";
                    break;
                }
                case 1: {
                    string2 = "DVST 15;DVSM 4";
                    break;
                }
                case 2: {
                    string2 = "DVST 15;DVSM 2";
                }
            }
        } else if (string.equalsIgnoreCase("NBPC")) {
            switch (this.m_nbpc.getSelectedIndex()) {
                case 0: {
                    string2 = "NBPC 8";
                    break;
                }
                case 1: {
                    string2 = "NBPC 10";
                    break;
                }
                case 2: {
                    string2 = "NBPC 12";
                }
            }
        } else if (string.equalsIgnoreCase("GAMC")) {
            string2 = "GAMC " + (this.m_gamc.isSelected() ? "1" : "0");
        } else {
            this.setCursor(cursor);
            return;
        }
        if (string2.length() == 0) {
            this.setCursor(cursor);
            return;
        }
        try {
            ImageControlPage.sendCmd(string2);
            ImageControlPage.sendCmd("FMTU");
        }
        catch (InstrumentException instrumentException) {
            this.setCursor(cursor);
            return;
        }
        this.getFormatValues();
        this.setCursor(cursor);
    }
}

